<?php
namespace Mainto\Bridge\Invokes\OaProject;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method loginDetailByParams(array $params)
 * @method changeStaffIdByParams(array $params)
 */
class UserStaffPermission {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取管理员权限信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginDetail () {
        return self::getClass()->loginDetail();
    }

    /**
     * 更改当前用户
     *
     * @param  int $staff_id 盘点id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStaffId (int $staff_id) {
        return self::getClass()->changeStaffId([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'UserStaffPermission');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'UserStaffPermission');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}