<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Satisfaction;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method noticeByParams(array $params)
 * @method checkImportInfoByParams(array $params)
 */
class Satisfaction {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $startAt 评分开始时间 [ require true ]
     * @param  string $endAt 评分结束时间 [ require true ]
     * @param  array $info 配置信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, string $startAt, string $endAt, array $info) {
        return self::getClass()->create([
            "name" => $name,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "info" => $info,
        ]);
    }

    /**
     * 编辑
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $name 名称 [ require true ]
     * @support  string $startAt 评分开始时间 
     * @support  string $endAt 评分结束时间 
     * @support  array $info 配置信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 列表
     *
     * @support  string $name 名称 
     * @support  string $status 状态 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $id 满意度id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id 满意度id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 通知(ding一下)
     *
     * @param  int $id 满意度id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function notice (int $id) {
        return self::getClass()->notice([
            "id" => $id,
        ]);
    }

    /**
     * 检查导入配置信息
     *
     * @param  array $info info [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkImportInfo (array $info) {
        return self::getClass()->checkImportInfo([
            "info" => $info,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Satisfaction\Satisfaction');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Satisfaction\Satisfaction');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}