<?php
namespace Mainto\Bridge\Invokes\OaProject\User\Satisfaction;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveByParams(array $params)
 * @method submitByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method getStatisticsByParams(array $params)
 */
class Satisfaction {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 提交评分
     *
     * @param  int $scoreId 评分记录id [Original type uint] [ require true ]
     * @param  array $scoreInfo 评分信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function save (int $scoreId, array $scoreInfo) {
        return self::getClass()->save([
            "scoreId" => $scoreId,
            "scoreInfo" => $scoreInfo,
        ]);
    }

    /**
     * 提交评分
     *
     * @param  int $scoreId 评分记录id [Original type uint] [ require true ]
     * @param  array $scoreInfo 评分信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $scoreId, array $scoreInfo) {
        return self::getClass()->submit([
            "scoreId" => $scoreId,
            "scoreInfo" => $scoreInfo,
        ]);
    }

    /**
     * 列表
     *
     * @support  string $name 名称 
     * @support  string $status 状态 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $id 满意度id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取评价状态数量
     *
     * @param  int $id 满意度id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStatistics (int $id) {
        return self::getClass()->getStatistics([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'User\Satisfaction\Satisfaction');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'User\Satisfaction\Satisfaction');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}