<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\StoreStaff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 录入(门店权限)
     *
     * @param  string $name 姓名 [ require true ]
     * @support  string $status 员工状态 [ require true ]
     * @support  string $type 员工类型 [ require true ]
     * @param  string $entry_at 入职日期 [ require true ]
     * @support  string $positive_at 转正日期 [ require true ]
     * @param  string $phone 手机 [ require true ]
     * @support  string $rest_type 休息类型 [ require true ]
     * @support  string $remark 备注 
     * @param  int $department_id 部门id [Original type uint] [ require true ]
     * @param  int $position_id 职位id [Original type uint] [ require true ]
     * @param  string $level 职级 [ require true ]
     * @support  string $attribute 伙伴属性(自有或加盟) [ require true ]
     * @support  string $job_title 技术职称 
     * @support  string $job_type 工作组(组长或无) 
     * @support  array $personal_info 个人其他信息 [ require true ]
     * @support  array $contract_info 合同信息 [ require true ]
     * @support  array $education_info 学历信息 [ require true ]
     * @support  array $experience_info 工作经历信息 
     * @support  array $annex 附件 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, string $entry_at, string $phone, int $department_id, int $position_id, string $level) {
        return self::getClass()->create([
            "name" => $name,
            "entry_at" => $entry_at,
            "phone" => $phone,
            "department_id" => $department_id,
            "position_id" => $position_id,
            "level" => $level,
        ]);
    }

    /**
     * 列表(门店权限)
     *
     * @param  array $department_ids 部门id [ require true ]
     * @support  int $position_id 职位 [Original type uint] 
     * @support  string $level 职级 
     * @support  string $entry_at_start 入职开始时间 
     * @support  string $entry_at_end 入职结束时间 
     * @support  string $positive_at_start 转正开始时间 
     * @support  string $positive_at_end 转正结束时间 
     * @support  string $end_at_start 合同开始时间 
     * @support  string $end_at_end 合同结束时间 
     * @support  int $id 工号 [Original type uint] 
     * @support  string $name 姓名 
     * @support  string $nickname 花名 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (array $department_ids, int $page = 1, int $page_size = 10) {
        return self::getClass()->list([
            "department_ids" => $department_ids,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 详情(门店权限)
     *
     * @param  int $id 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\StoreStaff\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\StoreStaff\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}