<?php
namespace Mainto\Bridge\Invokes\OaProject\User\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method getListByParams(array $params)
 */
class InventoryRelation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 所有评分记录
     *
     * @support  bool $with_count 包含总分 
     * @param  int $inventory_id 项目id [Original type uint] [ require true ]
     * @support  array $to_staff_ids 伙伴ids [Original type array&lt;uint&gt;] 
     * @support  string $staff_keyword 伙伴搜索关键词 
     * @throws  \Exception
     * @return  array
     */
    public static function all (int $inventory_id) {
        return self::getClass()->all([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 被评人评分列表
     *
     * @param  string $assessMainType 评分类型（opinion_value 价值观|management_ability管理能力） [ require true ]
     * @param  int $inventoryId 盘点id [ require true ]
     * @support  string $assessType 管理能力 tab 类型 
     * @support  array $relationType 评价关系 
     * @support  array $toStaffIds 搜索指定的伙伴 
     * @param  int $page  [ require true ]
     * @param  int $pageSize  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (string $assessMainType, int $inventoryId, int $page, int $pageSize) {
        return self::getClass()->getList([
            "assessMainType" => $assessMainType,
            "inventoryId" => $inventoryId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'User\Inventory\InventoryRelation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'User\Inventory\InventoryRelation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}