<?php
namespace Mainto\Bridge\Invokes\OaProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method keywordSearchByParams(array $params)
 * @method detailByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询伙伴信息-返回伙伴基础信息和职位信息 无条件 则返回空
     *
     * @support  array $staff_ids 工号ids [Original type array&lt;uint&gt;] 
     * @support  array $dept_ids 部门ids [Original type array&lt;uint&gt;] 
     * @support  array $position_ids 职位ids [Original type array&lt;uint&gt;] 
     * @support  string $keyword 工号|花名|姓名 
     * @param  bool $with_delete 包含离职 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (bool $with_delete = false) {
        return self::getClass()->all([
            "with_delete" => $with_delete,
        ]);
    }

    /**
     * 工号花名姓名搜索
     *
     * @param  string $keyword 工号|花名|姓名 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function keywordSearch (string $keyword) {
        return self::getClass()->keywordSearch([
            "keyword" => $keyword,
        ]);
    }

    /**
     * 详情
     *
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'User\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'User\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}