<?php
namespace Mainto\Bridge\Invokes\OaProject\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method getListByParams(array $params)
 * @method getPersonalListByParams(array $params)
 */
class Category {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加课程分类
     *
     * @support  string $name 分类名称 [ require true ]
     * @support  string $apply_in 应用于 [ require true ]
     * @support  array $label_ids 标签id [Original type array&lt;uint&gt;] 
     * @support  array $extend 拓展信息 
     * @support  string $type 分类类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * 修改课程分类
     *
     * @support  int $id id [ require true ]
     * @support  string $name 分类名称 
     * @support  array $label_ids 标签id数组 [Original type array&lt;uint&gt;] 
     * @support  string $apply_in 应用于 
     * @support  array $extend 拓展信息 
     * @support  string $type 分类类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除课程分类
     *
     * @support  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 获取课程分类列表【分页】
     *
     * @support  string $name 分类名称 
     * @support  string $apply_in 应用于 
     * @support  string $type 类型 
     * @support  bool $with_label 是否返回标签 
     * @param  bool $withStatistic 是否需要统计 [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 记录数 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (bool $withStatistic) {
        return self::getClass()->getListByPage([
            "withStatistic" => $withStatistic,
        ]);
    }

    /**
     * 获取课程分类列表
     *
     * @support  string $apply_in 应用于 
     * @support  string $type 课程类型 
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 课程分类统计【用户端】
     *
     * @param  string $category_type 课程类型 [ require true ]
     * @support  array $category_ids 课程分类id数组 [Original type array&lt;uint&gt;] 
     * @throws  \Exception
     * @return  array
     */
    public static function getPersonalList (string $category_type) {
        return self::getClass()->getPersonalList([
            "category_type" => $category_type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Category');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Category');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}