<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByPageByParams(array $params)
 * @method topByParams(array $params)
 * @method unTopByParams(array $params)
 * @method deleteMessageByParams(array $params)
 */
class CommentManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 留言列表
     *
     * @support  int $category_id 课程分类id [Original type uint] 
     * @support  string $content 关键词 
     * @support  string $name 关键词 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage () {
        return self::getClass()->getListByPage();
    }

    /**
     * 置顶
     *
     * @param  int $id 留言id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function top (int $id) {
        return self::getClass()->top([
            "id" => $id,
        ]);
    }

    /**
     * 取消置顶
     *
     * @param  int $id 留言id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unTop (int $id) {
        return self::getClass()->unTop([
            "id" => $id,
        ]);
    }

    /**
     * 删除留言
     *
     * @param  int $id 留言id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteMessage (int $id) {
        return self::getClass()->deleteMessage([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'CommentManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'CommentManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}