<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method exitExamByParams(array $params)
 * @method submitExamByParams(array $params)
 * @method beginExamByParams(array $params)
 * @method submitNodeAnswerByParams(array $params)
 * @method getAnswerInfoByParams(array $params)
 * @method getSchedulesByCourseIdByParams(array $params)
 */
class StoreExam {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退出考试
     *
     * @param  int $schedule_id 试卷任务id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exitExam (int $schedule_id) {
        return self::getClass()->exitExam([
            "schedule_id" => $schedule_id,
        ]);
    }

    /**
     * 提交试卷
     *
     * @param  array $answer_info_arr 回答信息组 [ require true ]
     * @param  int $schedule_id 试卷任务id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitExam (int $schedule_id, array $answer_info_arr = []) {
        return self::getClass()->submitExam([
            "schedule_id" => $schedule_id,
            "answer_info_arr" => $answer_info_arr,
        ]);
    }

    /**
     * 随机配置试卷题目
     *
     * @param  int $exam_id 试卷id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function beginExam (int $exam_id) {
        return self::getClass()->beginExam([
            "exam_id" => $exam_id,
        ]);
    }

    /**
     * 提交节点
     *
     * @param  int $schedule_id 试卷任务id [ require true ]
     * @param  array $answer_info 回答信息组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitNodeAnswer (int $schedule_id, array $answer_info) {
        return self::getClass()->submitNodeAnswer([
            "schedule_id" => $schedule_id,
            "answer_info" => $answer_info,
        ]);
    }

    /**
     * 获取错题
     *
     * @param  int $schedule_id 试卷任务id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAnswerInfo (int $schedule_id) {
        return self::getClass()->getAnswerInfo([
            "schedule_id" => $schedule_id,
        ]);
    }

    /**
     * 根据试卷id获取课程进度
     *
     * @param  int $course_id 试卷id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSchedulesByCourseId (int $course_id) {
        return self::getClass()->getSchedulesByCourseId([
            "course_id" => $course_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'StoreExam');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'StoreExam');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}