<?php
namespace Mainto\Bridge\Invokes\OaProject\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method examListByPageByParams(array $params)
 * @method examListByParams(array $params)
 * @method onlineByParams(array $params)
 * @method offlineByParams(array $params)
 * @method getExamInfoByParams(array $params)
 * @method getExamTypeByParams(array $params)
 * @method getInfoByParams(array $params)
 */
class Exam {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 试卷列表(分页)
     *
     * @support  string $name 试卷名称 
     * @support  string $is_released 是否上线 
     * @support  string $category 试卷类别 [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 页码 
     * @support  string $apply_in 页码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function examListByPage () {
        return self::getClass()->examListByPage();
    }

    /**
     * 试卷列表(不分页)
     *
     * @support  string $name 试卷名称 
     * @support  string $is_released 是否上线 
     * @support  string $category 试卷类别 
     * @support  string $type 试卷类型 
     * @support  bool $has_learn_data 是否关联学习资料 
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  array
     */
    public static function examList () {
        return self::getClass()->examList();
    }

    /**
     * 试卷上线
     *
     * @param  int $id 主课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function online (int $id) {
        return self::getClass()->online([
            "id" => $id,
        ]);
    }

    /**
     * 试卷下线
     *
     * @param  int $id 主课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline (int $id) {
        return self::getClass()->offline([
            "id" => $id,
        ]);
    }

    /**
     * 获取试卷的详细信息
     *
     * @param  int $id 试卷id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExamInfo (int $id) {
        return self::getClass()->getExamInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取试卷类型
     *
     * @param  string $apply_in 应用于 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExamType (string $apply_in) {
        return self::getClass()->getExamType([
            "apply_in" => $apply_in,
        ]);
    }

    /**
     * 评审详情
     *
     * @param  int $schedule_id 试卷任务id [ require true ]
     * @param  int $staff_num 员工工号 [ require true ]
     * @param  bool $with_reviewer 是否需要评分人信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $schedule_id, int $staff_num, bool $with_reviewer = false) {
        return self::getClass()->getInfo([
            "schedule_id" => $schedule_id,
            "staff_num" => $staff_num,
            "with_reviewer" => $with_reviewer,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Exam');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Exam');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}