<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Organization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method detailByParams(array $params)
 * @method getDetailsByIdsByParams(array $params)
 * @method allTypesByParams(array $params)
 * @method syncSubjectListByParams(array $params)
 * @method getSubjectsByParams(array $params)
 * @method getCostTypeByParams(array $params)
 * @method getStaffsByDeptDingIdFromDingByParams(array $params)
 * @method syncDepartmentsToNsByParams(array $params)
 * @method autoSyncManagerStaffByParams(array $params)
 */
class Department {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增部门
     *
     * @param  string $name 部门名称 [ require true ]
     * @param  int $parent 上级部门 [Original type uint] [ require true ]
     * @param  int $type 部门类型 [Original type uint] [ require true ]
     * @param  int $subjectId 部门主体id [Original type uint] [ require true ]
     * @param  int $costType 财务属性id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function create (string $name, int $parent, int $type, int $subjectId, int $costType) {
        return self::getClass()->create([
            "name" => $name,
            "parent" => $parent,
            "type" => $type,
            "subjectId" => $subjectId,
            "costType" => $costType,
        ]);
    }

    /**
     * 修改部门
     *
     * @param  int $id 部门id [Original type uint] [ require true ]
     * @support  string $name 部门名称 
     * @support  int $parent 上级部门 [Original type uint] 
     * @support  int $subjectId 部门主体id [Original type uint] 
     * @support  int $dingManagerStaffId 部门负责人工号 [Original type uint] 
     * @param  int $costType 财务属性id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, int $costType) {
        return self::getClass()->update([
            "id" => $id,
            "costType" => $costType,
        ]);
    }

    /**
     * 删除部门
     *
     * @param  int $id 部门id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 部门详情
     *
     * @param  int $id 部门id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 根据ids获取部门详情
     *
     * @param  array $ids 部门id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetailsByIds (array $ids) {
        return self::getClass()->getDetailsByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 类型列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function allTypes () {
        return self::getClass()->allTypes();
    }

    /**
     * 从ns同步主体列表 10分钟一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncSubjectList () {
        return self::getClass()->syncSubjectList();
    }

    /**
     * 获取主体列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSubjects () {
        return self::getClass()->getSubjects();
    }

    /**
     * 获取财务属性列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCostType () {
        return self::getClass()->getCostType();
    }

    /**
     * 从钉钉获取部门下的伙伴
     *
     * @param  string $deptDingId 部门id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffsByDeptDingIdFromDing (string $deptDingId) {
        return self::getClass()->getStaffsByDeptDingIdFromDing([
            "deptDingId" => $deptDingId,
        ]);
    }

    /**
     * 批量同步部门到NS
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncDepartmentsToNs () {
        return self::getClass()->syncDepartmentsToNs();
    }

    /**
     * 定时更新部门伙伴的主管数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSyncManagerStaff () {
        return self::getClass()->autoSyncManagerStaff();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Organization\Department');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Organization\Department');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}