<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addCourseByParams(array $params)
 * @method videoProcessByParams(array $params)
 * @method editCourseByParams(array $params)
 * @method editCourseReleaseByParams(array $params)
 * @method getListByParams(array $params)
 * @method getSortCourseByParams(array $params)
 * @method getDataListByPageByParams(array $params)
 * @method getDataInfoByParams(array $params)
 * @method getStoreByDeptIdByParams(array $params)
 */
class CourseManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建课程
     *
     * @support  int $category_id 课程分类id [ require true ]
     * @support  string $name 课程名称 [ require true ]
     * @support  array $label_ids 标签id数组 [Original type array&lt;uint&gt;] 
     * @support  string $description 课程描述 [ require true ]
     * @support  string $image_path 课程封面图 [ require true ]
     * @support  array $can_rule 前置条件 
     * @support  int $pass_credit 课程学分 [Original type uint] [ require true ]
     * @support  array $children 子课程配置 
     * @support  array $groups 适用分组 [Original type array&lt;int&gt;] [ require true ]
     * @support  array $learn_data 学习资料 
     * @support  int $teacher_id 讲师id [Original type uint] 
     * @support  array $sort_rule 扩展信息的作用 
     * @throws  \Exception
     * @return  int
     */
    public static function addCourse () {
        return self::getClass()->addCourse();
    }

    /**
     * 定时任务 进度查询
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function videoProcess () {
        return self::getClass()->videoProcess();
    }

    /**
     * 修改课程
     *
     * @support  int $id 课程id [ require true ]
     * @support  int $category_id 课程分类id [ require true ]
     * @support  array $label_ids 标签id数组 [Original type array&lt;uint&gt;] 
     * @support  string $name 课程名称 [ require true ]
     * @support  string $description 课程描述 [ require true ]
     * @support  string $image_path 课程封面图 [ require true ]
     * @support  array $can_rule 前置条件 
     * @support  array $children 子课程配置 
     * @support  array $groups 适用分组 [Original type array&lt;int&gt;] [ require true ]
     * @support  array $learn_data 学习资料 
     * @support  int $teacher_id 讲师id [Original type uint] 
     * @support  array $sort_rule 扩展信息的作用 
     * @param  bool $video_transcoding 是否转码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editCourse (bool $video_transcoding) {
        return self::getClass()->editCourse([
            "video_transcoding" => $video_transcoding,
        ]);
    }

    /**
     * 在线修改课程
     *
     * @support  int $id 课程id [ require true ]
     * @support  int $category_id 课程分类id 
     * @support  array $label_ids 标签id数组 [Original type array&lt;uint&gt;] 
     * @support  string $name 课程名称 
     * @support  string $description 课程描述 
     * @support  string $image_path 课程封面图 
     * @support  array $groups 适用分组 [Original type array&lt;int&gt;] 
     * @support  array $sort_rule 扩展信息的作用 
     * @support  array $can_rule 前置条件 
     * @support  array $learn_data 学习资料 
     * @support  int $teacher_id 讲师id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editCourseRelease () {
        return self::getClass()->editCourseRelease();
    }

    /**
     * 课程列表【不分页】
     *
     * @support  array $category_ids 课程分类ids [Original type array&lt;int&gt;] 
     * @support  int $is_released 是否已上线 
     * @support  bool $with_groups_info 包含分组信息 
     * @support  bool $has_exam 关联练习 
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 获取排序课程
     *
     * @param  array $group_ids 组id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSortCourse (array $group_ids) {
        return self::getClass()->getSortCourse([
            "group_ids" => $group_ids,
        ]);
    }

    /**
     * 课程数据列表
     *
     * @param  string $category_type 课程类型 [ require true ]
     * @support  array $category_ids 课程分类ids [Original type array&lt;int&gt;] [ require true ]
     * @support  string $name 课程名称发【模糊查询】 
     * @support  int $page 页码 
     * @support  int $pageSize 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getDataListByPage (string $category_type) {
        return self::getClass()->getDataListByPage([
            "category_type" => $category_type,
        ]);
    }

    /**
     * 课程数据列表详情
     *
     * @param  int $course_id 课程id [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDataInfo (int $course_id, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getDataInfo([
            "course_id" => $course_id,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据部门id获取门店
     *
     * @param  int $dept_id 课程id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreByDeptId (int $dept_id) {
        return self::getClass()->getStoreByDeptId([
            "dept_id" => $dept_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'CourseManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'CourseManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}