<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPlaceListByParams(array $params)
 * @method getTripLogsByParams(array $params)
 * @method retrySyncByParams(array $params)
 * @method oldSyncByParams(array $params)
 */
class TripProcess {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取地址信息
     *
     * @support  string $name 地名 
     * @support  string $code 地点编号 
     * @throws  \Exception
     * @return  array
     */
    public static function getPlaceList () {
        return self::getClass()->getPlaceList();
    }

    /**
     * 获取同步历史
     *
     * @support  bool $isSuccess 是否成功同步 
     * @support  array $processResult 审批状态 
     * @throws  \Exception
     * @return  array
     */
    public static function getTripLogs () {
        return self::getClass()->getTripLogs();
    }

    /**
     * 重新同步
     *
     * @param  string $processInstanceId 实例id [ require true ]
     * @support  array $patchData 修改内容 
     * @throws  \Exception
     * @return  mixed
     */
    public static function retrySync (string $processInstanceId) {
        return self::getClass()->retrySync([
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * oldSync
     *
     * @param  string $startTimestamp 开始时间戳 13位 [ require true ]
     * @param  string $endTimestamp 结束时间戳 13位 [ require true ]
     * @support  array $businessIds 审批编号组 
     * @support  array $staffIds 工号组 
     * @throws  \Exception
     * @return  array
     */
    public static function oldSync (string $startTimestamp, string $endTimestamp) {
        return self::getClass()->oldSync([
            "startTimestamp" => $startTimestamp,
            "endTimestamp" => $endTimestamp,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\TripProcess');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\TripProcess');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}