<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addExampleByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updateByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method getStoreExampleListByPageByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getStoreInfoByParams(array $params)
 * @method onlineByParams(array $params)
 * @method offlineByParams(array $params)
 * @method topByParams(array $params)
 * @method unTopByParams(array $params)
 */
class ExampleManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  string $title 标题 [ require true ]
     * @support  int $category_id 分类id [ require true ]
     * @support  array $position_ids 分组 [ require true ]
     * @support  string $origin 来源 [ require true ]
     * @support  array $extend 拓展信息 [ require true ]
     * @support  string $content 内容 [ require true ]
     * @support  int $top 置顶序号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addExample () {
        return self::getClass()->addExample();
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 更新记录
     *
     * @support  string $_id id [ require true ]
     * @support  string $title 标题 
     * @support  int $category_id 分类id 
     * @support  array $position_ids 分组 
     * @support  string $origin 来源 
     * @support  array $extend 拓展信息 
     * @support  string $content 内容 
     * @support  bool $is_released 是否上线 
     * @support  int $top 置顶序号 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 列表查询【泽维尔】
     *
     * @support  string $title 标题 
     * @support  int $category_id 分类id 
     * @support  bool $is_released 是否上线 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页数量 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage () {
        return self::getClass()->getListByPage();
    }

    /**
     * 列表查询【门店伙伴】
     *
     * @support  string $title 标题 
     * @support  array $category_ids 分类id [Original type array&lt;int&gt;] 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页数量 [Original type uint] 
     * @support  string $created_at_start 创建时间起 
     * @support  string $created_at_end 创建时间止 
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreExampleListByPage () {
        return self::getClass()->getStoreExampleListByPage();
    }

    /**
     * 获取单条详情【泽维尔】
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 获取案例详情【门店】
     *
     * @param  int $id 案例id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreInfo (int $id) {
        return self::getClass()->getStoreInfo([
            "id" => $id,
        ]);
    }

    /**
     * 上线
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function online (string $_id) {
        return self::getClass()->online([
            "_id" => $_id,
        ]);
    }

    /**
     * 下线
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline (string $_id) {
        return self::getClass()->offline([
            "_id" => $_id,
        ]);
    }

    /**
     * 置顶【置顶最多置顶三个】
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function top (string $_id) {
        return self::getClass()->top([
            "_id" => $_id,
        ]);
    }

    /**
     * 取消置顶
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unTop (string $_id) {
        return self::getClass()->unTop([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'ExampleManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'ExampleManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}