<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createReviewByParams(array $params)
 * @method approvalHookByParams(array $params)
 * @method getPersonalInfoByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getPersonalListByPageByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method addReviewerByParams(array $params)
 * @method delReviewerByParams(array $params)
 * @method getReviewerListByPageByParams(array $params)
 */
class StoreExample {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户端提交案例(发起钉钉审批)
     *
     * @support  int $category_id 案例分类 
     * @support  string $title 案例标题 
     * @support  string $origin 案例来源 
     * @support  string $happen_time 发生时间 
     * @support  string $happen_address 发生地点 
     * @support  string $relation_person 相关人物 
     * @support  string $content 内容 [ require true ]
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createReview () {
        return self::getClass()->createReview();
    }

    /**
     * 审批事件回调监听
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHook () {
        return self::getClass()->approvalHook();
    }

    /**
     * 获取案例详情【门店】
     *
     * @param  int $id 案例id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPersonalInfo (int $id) {
        return self::getClass()->getPersonalInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取案例详情【泽维尔】
     *
     * @param  string $_id 案例id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 用户提交记录【用户添加】
     *
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getPersonalListByPage () {
        return self::getClass()->getPersonalListByPage();
    }

    /**
     * 列表查询【泽维尔添加】
     *
     * @support  string $title 标题 
     * @support  int $category_id 分类id 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage () {
        return self::getClass()->getListByPage();
    }

    /**
     * 添加审批人
     *
     * @param  int $staff_num 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addReviewer (int $staff_num) {
        return self::getClass()->addReviewer([
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 删除审批人
     *
     * @param  string $_id 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function delReviewer (string $_id) {
        return self::getClass()->delReviewer([
            "_id" => $_id,
        ]);
    }

    /**
     * 审批人列表
     *
     * @support  int $page 页码 
     * @support  int $page_size 每页显示数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getReviewerListByPage () {
        return self::getClass()->getReviewerListByPage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'StoreExample');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'StoreExample');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}