<?php
namespace Mainto\Bridge\Invokes\OaProject\Cloud\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getChildCourseInfoByParams(array $params)
 * @method beginMainCourseByParams(array $params)
 * @method beginChildCourseByParams(array $params)
 * @method breakCourseByParams(array $params)
 */
class CloudCourse {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 子课程详情【用户端】
     *
     * @param  int $id 课程ID [ require true ]
     * @param  int $staff_num 员工工号 [ require true ]
     * @param  bool $with_state 是否需要学习状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getChildCourseInfo (int $id, int $staff_num, bool $with_state = false) {
        return self::getClass()->getChildCourseInfo([
            "id" => $id,
            "staff_num" => $staff_num,
            "with_state" => $with_state,
        ]);
    }

    /**
     * 开始主课程
     *
     * @param  int $course_id 主课程id [ require true ]
     * @param  int $staff_id 员工工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function beginMainCourse (int $course_id, int $staff_id) {
        return self::getClass()->beginMainCourse([
            "course_id" => $course_id,
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 开始子课程
     *
     * @param  int $child_course_id 子课程id [ require true ]
     * @param  int $staff_id 员工工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function beginChildCourse (int $child_course_id, int $staff_id) {
        return self::getClass()->beginChildCourse([
            "child_course_id" => $child_course_id,
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 中断课程
     *
     * @param  int $course_id 主课程id [ require true ]
     * @param  int $append_time 新增学习时间 [ require true ]
     * @param  int $staff_id 员工工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function breakCourse (int $course_id, int $staff_id, int $append_time) {
        return self::getClass()->breakCourse([
            "course_id" => $course_id,
            "staff_id" => $staff_id,
            "append_time" => $append_time,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'CloudCourse');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'CloudCourse');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}