<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method interactiveCreditIncreaseByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method expenseByParams(array $params)
 */
class CreditManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 增加互动积分
     *
     * @support  int $credit 积分 [Original type uint] [ require true ]
     * @support  int $ref_id 对应id [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function interactiveCreditIncrease () {
        return self::getClass()->interactiveCreditIncrease();
    }

    /**
     * 学分列表
     *
     * @support  string $created_at_start 创建时间起 
     * @support  string $created_at_end 创建时间止 
     * @param  string $type 类型 [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (string $type = '') {
        return self::getClass()->getListByPage([
            "type" => $type,
        ]);
    }

    /**
     * 支出统计
     *
     * @throws  \Exception
     * @return  array
     */
    public static function expense () {
        return self::getClass()->expense();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'CreditManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'CreditManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}