<?php
namespace Mainto\Bridge\Invokes\OaProject\Cloud\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffByJobsByParams(array $params)
 * @method getStaffInfoByIdsByParams(array $params)
 * @method getAllJobsByParams(array $params)
 * @method staffArchiveListByParams(array $params)
 * @method personalArchiveListByParams(array $params)
 * @method getStaffArchiveInfoByParams(array $params)
 * @method personalCategoryListByParams(array $params)
 * @method personalCourseListByParams(array $params)
 */
class CloudStaff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 花名或真名搜索部门下的员工
     *
     * @param  array $jobs 按岗位 [ require true ]
     * @support  string $name 姓名或花名 
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffByJobs (array $jobs) {
        return self::getClass()->getStaffByJobs([
            "jobs" => $jobs,
        ]);
    }

    /**
     * 批量ID获取员工信息
     *
     * @support  array $ids 伙伴ID 
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffInfoByIds () {
        return self::getClass()->getStaffInfoByIds();
    }

    /**
     * 获得所有岗位
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllJobs () {
        return self::getClass()->getAllJobs();
    }

    /**
     * 员工档案列表
     *
     * @support  string $name 员工姓名或花名 
     * @support  string $category 试卷类型 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function staffArchiveList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->staffArchiveList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 个人档案列表(用户端)
     *
     * @param  string $category 试卷类型 [ require true ]
     * @param  int $staff_num 工号 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @support  int $pageSize 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function personalArchiveList (int $staff_num, string $category, int $page = 1) {
        return self::getClass()->personalArchiveList([
            "staff_num" => $staff_num,
            "category" => $category,
            "page" => $page,
        ]);
    }

    /**
     * 员工档案详情
     *
     * @param  int $staff_id 员工姓名或花名 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffArchiveInfo (int $staff_id) {
        return self::getClass()->getStaffArchiveInfo([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 个人分类列表
     *
     * @param  int $staff_id 员工工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function personalCategoryList (int $staff_id) {
        return self::getClass()->personalCategoryList([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 个人课程列表
     *
     * @support  array $category_ids 课程分类ids [Original type array&lt;int&gt;] [ require true ]
     * @support  int $is_released 是否上线 [ require true ]
     * @param  int $staff_num 伙伴工号 [ require true ]
     * @support  string $name 课程名称 
     * @support  int $page 页码 
     * @support  int $pageSize 每页记录数 
     * @throws  \Exception
     * @return  array
     */
    public static function personalCourseList (int $staff_num) {
        return self::getClass()->personalCourseList([
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'CloudStaff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'CloudStaff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}