<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addCommentByParams(array $params)
 * @method deleteCommentByParams(array $params)
 * @method getCommentListByPageByParams(array $params)
 * @method likeByParams(array $params)
 * @method dislikeByParams(array $params)
 */
class StoreComment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 课程留言
     *
     * @param  int $course_id 课程id [Original type uint] [ require true ]
     * @param  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addComment (int $course_id, string $content) {
        return self::getClass()->addComment([
            "course_id" => $course_id,
            "content" => $content,
        ]);
    }

    /**
     * 删除留言
     *
     * @param  int $id 留言id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteComment (int $id) {
        return self::getClass()->deleteComment([
            "id" => $id,
        ]);
    }

    /**
     * 获取列表-分页
     *
     * @support  int $course_id 课程id [ require true ]
     * @support  int $page 页数 
     * @support  int $pageSize 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getCommentListByPage () {
        return self::getClass()->getCommentListByPage();
    }

    /**
     * 点赞留言
     *
     * @param  int $id 课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function like (int $id) {
        return self::getClass()->like([
            "id" => $id,
        ]);
    }

    /**
     * 取消点赞【点赞删除的同时，点赞数也要减1】
     *
     * @param  int $id 课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dislike (int $id) {
        return self::getClass()->dislike([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'StoreComment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'StoreComment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}