<?php
namespace Mainto\Bridge\Invokes\OaProject\Cloud\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addExamByParams(array $params)
 * @method editExamByParams(array $params)
 * @method getQuestionTypeByParams(array $params)
 * @method reviewByParams(array $params)
 * @method reviewListByPageByParams(array $params)
 */
class CloudExamManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加试卷
     *
     * @support  string $category 分类名称 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @support  array $can_rule 前置条件 
     * @support  string $name 试卷名称 [ require true ]
     * @support  int $time 限时(秒) 
     * @support  string $description 试卷描述 [ require true ]
     * @support  int $pass_score 通过分数 [ require true ]
     * @support  int $pass_credit 通过学分 [ require true ]
     * @support  array $question_config 题型配置 [ require true ]
     * @support  array $question_ids 题目ids [Original type array&lt;int&gt;] 
     * @support  array $questions 题目 [ require true ]
     * @support  int $course_id 关联课程 
     * @support  array $group_ids 关联分组 
     * @support  array $extend 额外信息 
     * @support  array $answer_times_limit 答题次数限制 
     * @support  array $score_item 修图题评分项 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addExam () {
        return self::getClass()->addExam();
    }

    /**
     * 编辑试卷
     *
     * @support  int $id 试卷id [ require true ]
     * @support  string $category 分类名称 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @support  array $can_rule 前置条件 
     * @support  string $name 试卷名称 [ require true ]
     * @support  int $time 限时(秒) 
     * @support  string $description 试卷描述 [ require true ]
     * @support  int $pass_score 通过分数 [ require true ]
     * @support  int $pass_credit 通过学分 [ require true ]
     * @support  array $question_config 题型配置 [ require true ]
     * @support  array $question_ids 题目ids [Original type array&lt;int&gt;] 
     * @support  array $questions 题目 [ require true ]
     * @support  int $course_id 关联课程 
     * @support  array $group_ids 关联分组 
     * @support  array $extend 额外信息 
     * @support  array $answer_times_limit 答题次数限制 
     * @support  array $score_item 修图题评分项 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editExam () {
        return self::getClass()->editExam();
    }

    /**
     * 获取题型
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getQuestionType () {
        return self::getClass()->getQuestionType();
    }

    /**
     * 评分
     *
     * @param  array $answer_info_arr 回答信息组 [ require true ]
     * @param  int $schedule_id 试卷任务id [ require true ]
     * @param  int $staff_num 员工工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function review (int $staff_num, int $schedule_id, array $answer_info_arr) {
        return self::getClass()->review([
            "staff_num" => $staff_num,
            "schedule_id" => $schedule_id,
            "answer_info_arr" => $answer_info_arr,
        ]);
    }

    /**
     * 评分列表
     *
     * @param  array $status 状态位【done | pass |un_pass】 [ require true ]
     * @support  array $category_ids 主课程分类 
     * @param  string $category 试卷类型 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @support  string $staff_name 员工名字 
     * @support  string $course_name 课程名称 
     * @throws  \Exception
     * @return  array
     */
    public static function reviewListByPage (string $category, array $status, int $page = 1, int $pageSize = 10) {
        return self::getClass()->reviewListByPage([
            "category" => $category,
            "status" => $status,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'CloudExamManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'CloudExamManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}