<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method creditIncreaseByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method exchangeByParams(array $params)
 * @method getCreditTypeByParams(array $params)
 */
class StoreCredit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 增加学分
     *
     * @param  int $course_id 课程id [Original type uint] [ require true ]
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function creditIncrease (int $course_id) {
        return self::getClass()->creditIncrease([
            "course_id" => $course_id,
        ]);
    }

    /**
     * 积分列表
     *
     * @support  int $page 页码 
     * @support  int $pageSize 每页显示的数量 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByPage () {
        return self::getClass()->getListByPage();
    }

    /**
     * 兑换愿望值
     *
     * @param  int $wish_value 愿望值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exchange (int $wish_value) {
        return self::getClass()->exchange([
            "wish_value" => $wish_value,
        ]);
    }

    /**
     * 获取积分类型
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCreditType () {
        return self::getClass()->getCreditType();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'StoreCredit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'StoreCredit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}