<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByPageByParams(array $params)
 * @method getNewCourseByParams(array $params)
 * @method getNextCourseByParams(array $params)
 * @method remarkByParams(array $params)
 * @method beginMainCourseByParams(array $params)
 * @method getListByStateByParams(array $params)
 * @method getLearnStateStatisticsByParams(array $params)
 * @method getLearnStateByParams(array $params)
 */
class StoreCourse {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 课程列表
     *
     * @support  array $category_ids 课程分类ids [Original type array&lt;uint&gt;] 
     * @support  array $label_ids 标签ids [Original type array&lt;uint&gt;] 
     * @support  string $name 课程名称 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $pageSize 每页数据 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage () {
        return self::getClass()->getListByPage();
    }

    /**
     * 获取新课程
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getNewCourse () {
        return self::getClass()->getNewCourse();
    }

    /**
     * 获取下一门课程
     *
     * @param  int $course_id 试卷id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNextCourse (int $course_id) {
        return self::getClass()->getNextCourse([
            "course_id" => $course_id,
        ]);
    }

    /**
     * 课程标记【针对必修课程：音频|文档类型】
     *
     * @param  int $schedule_id 进度id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remark (int $schedule_id) {
        return self::getClass()->remark([
            "schedule_id" => $schedule_id,
        ]);
    }

    /**
     * 开始主课程
     *
     * @param  int $course_id 主课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function beginMainCourse (int $course_id) {
        return self::getClass()->beginMainCourse([
            "course_id" => $course_id,
        ]);
    }

    /**
     * 获取【学习】状态列表
     *
     * @param  string $state 状态 [ require true ]
     * @support  array $category_ids 课程分类ids [Original type array&lt;int&gt;] 
     * @support  int $page 页码 
     * @support  int $pageSize 每页显示数据 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByState (string $state) {
        return self::getClass()->getListByState([
            "state" => $state,
        ]);
    }

    /**
     * 学习状态统计【全部状态】
     *
     * @support  array $category_ids 课程分类ids [Original type array&lt;int&gt;] 
     * @throws  \Exception
     * @return  array
     */
    public static function getLearnStateStatistics () {
        return self::getClass()->getLearnStateStatistics();
    }

    /**
     * 获取学习状态
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getLearnState () {
        return self::getClass()->getLearnState();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'StoreCourse');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'StoreCourse');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}