<?php
namespace Mainto\Bridge\Invokes\OaProject\Cloud\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addCourseByParams(array $params)
 * @method editCourseByParams(array $params)
 * @method editCourseReleaseByParams(array $params)
 * @method getChildCourseInfoByParams(array $params)
 * @method onlineByParams(array $params)
 * @method offlineByParams(array $params)
 * @method learnInfoListByParams(array $params)
 */
class CloudCourseManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加主课程
     *
     * @support  int $category_id 课程分类id [ require true ]
     * @support  string $name 课程名称 [ require true ]
     * @support  string $description 课程描述 [ require true ]
     * @support  string $image_path 课程封面图 [ require true ]
     * @support  array $can_rule 前置条件 
     * @support  array $children 子课程 [ require true ]
     * @support  array $groups 适用分组 [ require true ]
     * @support  array $sort_rule 排序规则【提供给前端存放分组-规则排序】 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addCourse () {
        return self::getClass()->addCourse();
    }

    /**
     * 修改课程
     *
     * @support  int $id 课程id [ require true ]
     * @support  int $category_id 课程分类id 
     * @support  string $name 课程名称 
     * @support  string $description 课程描述 
     * @support  string $image_path 课程封面图 
     * @support  int $sequence 排序值 
     * @support  array $can_rule 前置条件 
     * @support  array $children 子课程配置 
     * @support  array $groups 适用分组 [Original type array&lt;int&gt;] 
     * @support  array $sort_rule 排序规则 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editCourse () {
        return self::getClass()->editCourse();
    }

    /**
     * 在线修改课程
     *
     * @support  int $id 课程id [ require true ]
     * @support  int $category_id 课程分类id 
     * @support  string $name 课程名称 
     * @support  string $description 课程描述 
     * @support  string $image_path 课程封面图 
     * @support  array $groups 适用分组 [Original type array&lt;int&gt;] 
     * @support  array $can_rule 前置条件 
     * @support  array $sort_rule 扩展信息的作用 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editCourseRelease () {
        return self::getClass()->editCourseRelease();
    }

    /**
     * 子课程详情【管理端】
     *
     * @param  int $id 课程ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getChildCourseInfo (int $id) {
        return self::getClass()->getChildCourseInfo([
            "id" => $id,
        ]);
    }

    /**
     * 课程上线
     *
     * @param  int $id 主课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function online (int $id) {
        return self::getClass()->online([
            "id" => $id,
        ]);
    }

    /**
     * 课程下线
     *
     * @param  int $id 主课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline (int $id) {
        return self::getClass()->offline([
            "id" => $id,
        ]);
    }

    /**
     * 课程学习人次详情
     *
     * @param  int $id 主课程id [ require true ]
     * @param  string $name 花名或姓名 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function learnInfoList (int $id, string $name = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->learnInfoList([
            "id" => $id,
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'CloudCourseManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'CloudCourseManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}