<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method typeListByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method getInfoByParams(array $params)
 */
class PersonnelChange {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 配置列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function typeList () {
        return self::getClass()->typeList();
    }

    /**
     * 列表
     *
     * @param  string $type 异动类型(入职entry转正turn_positive调岗transfer离职leave其他other) [ require true ]
     * @support  string $status 是否在职(在职work离职leave全部空) 
     * @support  int $staff_id 工号 [Original type uint] 
     * @support  string $name 姓名 
     * @support  string $nickname 花名 
     * @support  string $start_at 开始时间(入职、转正、调岗、离职的开始时间) 
     * @support  string $end_at 结束时间(入职、转正、调岗、离职的结束时间) 
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $page_size 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $type, int $page = 1, int $page_size = 10) {
        return self::getClass()->list([
            "type" => $type,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $staff_id 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $staff_id) {
        return self::getClass()->detail([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 获取导出详情接口
     *
     * @param  string $task_id 任务id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (string $task_id) {
        return self::getClass()->getInfo([
            "task_id" => $task_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Staff\PersonnelChange');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Staff\PersonnelChange');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}