<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\RBAC;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method permissionsByParams(array $params)
 */
class Admin {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * list
     *
     * @param  array $staff_ids 工号组 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (array $staff_ids = [], int $page = 1, int $page_size = 10) {
        return self::getClass()->list([
            "staff_ids" => $staff_ids,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 新增管理员
     *
     * @param  int $staff_id 工号 [Original type uint] [ require true ]
     * @param  int $role_id 角色id [Original type uint] [ require true ]
     * @param  array $permission_ids 权限组 [ require true ]
     * @param  array $department_permissions 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $staff_id, int $role_id, array $permission_ids = [], array $department_permissions = []) {
        return self::getClass()->create([
            "staff_id" => $staff_id,
            "role_id" => $role_id,
            "permission_ids" => $permission_ids,
            "department_permissions" => $department_permissions,
        ]);
    }

    /**
     * update
     *
     * @param  int $staff_id 工号 [Original type uint] [ require true ]
     * @param  int $role_id 角色id [Original type uint] [ require true ]
     * @param  array $permission_ids 权限组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $staff_id, int $role_id, array $permission_ids = []) {
        return self::getClass()->update([
            "staff_id" => $staff_id,
            "role_id" => $role_id,
            "permission_ids" => $permission_ids,
        ]);
    }

    /**
     * 删除管理员
     *
     * @param  int $staff_id 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $staff_id) {
        return self::getClass()->delete([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 管理员拥有的权限
     *
     * @param  int $staff_id 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function permissions (int $staff_id) {
        return self::getClass()->permissions([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\RBAC\Admin');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\RBAC\Admin');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}