<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\RBAC;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listByParams(array $params)
 * @method updateByParams(array $params)
 */
class Role {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  string $title 角色名 [ require true ]
     * @param  array $permission_ids 权限组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $title, array $permission_ids) {
        return self::getClass()->create([
            "title" => $title,
            "permission_ids" => $permission_ids,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id 角色id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 列表
     *
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @param  int $title 角色名模糊匹配 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $page_size = 20, int $title = '') {
        return self::getClass()->list([
            "page" => $page,
            "page_size" => $page_size,
            "title" => $title,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $id 角色id [Original type uint] [ require true ]
     * @support  string $title 角色名 
     * @support  array $permission_ids 权限组 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\RBAC\Role');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\RBAC\Role');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}