<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addCollectionByParams(array $params)
 * @method cancelCollectionByParams(array $params)
 * @method getListByPageByParams(array $params)
 */
class StoreCollection {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加课程收藏
     *
     * @param  int $course_id 课程id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addCollection (int $course_id) {
        return self::getClass()->addCollection([
            "course_id" => $course_id,
        ]);
    }

    /**
     * 取消课程收藏
     *
     * @param  int $id storage_id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function cancelCollection (int $id) {
        return self::getClass()->cancelCollection([
            "id" => $id,
        ]);
    }

    /**
     * 课程收藏列表
     *
     * @param  string $name 课程名称【模糊查询】 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (string $name = '', int $page, int $pageSize) {
        return self::getClass()->getListByPage([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'StoreCollection');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'StoreCollection');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}