<?php
namespace Mainto\Bridge\Invokes\OaProject\Cloud\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method beginExamByParams(array $params)
 * @method submitExamByParams(array $params)
 * @method personalExamListByParams(array $params)
 */
class CloudExam {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 随机配置试卷题目
     *
     * @param  int $exam_id 试卷id [ require true ]
     * @param  int $staff_id 员工工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function beginExam (int $exam_id, int $staff_id) {
        return self::getClass()->beginExam([
            "exam_id" => $exam_id,
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 提交试卷
     *
     * @param  array $answer_info_arr 回答信息组 [ require true ]
     * @param  int $schedule_id 试卷任务id [ require true ]
     * @param  int $staff_id 员工工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitExam (int $schedule_id, array $answer_info_arr, int $staff_id) {
        return self::getClass()->submitExam([
            "schedule_id" => $schedule_id,
            "answer_info_arr" => $answer_info_arr,
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 个人试卷列表
     *
     * @param  string $category 试卷分类 [ require true ]
     * @param  string $status 完成状态【完成：complete  未完成：pending】 [ require true ]
     * @param  int $staff_num 员工工号 [Original type uint] [ require true ]
     * @param  string $name 试卷名称 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function personalExamList (string $category, string $status, int $staff_num, string $name = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->personalExamList([
            "category" => $category,
            "status" => $status,
            "staff_num" => $staff_num,
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'CloudExam');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'CloudExam');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}