<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method correctByParams(array $params)
 * @method cancelCorrectByParams(array $params)
 * @method statusByParams(array $params)
 * @method finalCalcByParams(array $params)
 * @method saveDrawByParams(array $params)
 * @method getDrawByParams(array $params)
 */
class InventoryStatistic {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 评分统计
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @support  array $to_staff_ids 被评员工id [Original type array&lt;uint&gt;] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @support  string $status 评分类型 
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $inventory_id, int $page = 1, int $page_size = 10) {
        return self::getClass()->list([
            "inventory_id" => $inventory_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 纠偏
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function correct (int $inventory_id) {
        return self::getClass()->correct([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 撤销纠偏
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelCorrect (int $inventory_id) {
        return self::getClass()->cancelCorrect([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 计算状态
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function status (int $inventory_id) {
        return self::getClass()->status([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 系统计算最终得分
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finalCalc (int $inventory_id) {
        return self::getClass()->finalCalc([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 导入最终绘图数据
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @param  string $assess_type 盘点类型 [ require true ]
     * @param  array $draw_data 数据信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveDraw (int $inventory_id, string $assess_type, array $draw_data) {
        return self::getClass()->saveDraw([
            "inventory_id" => $inventory_id,
            "assess_type" => $assess_type,
            "draw_data" => $draw_data,
        ]);
    }

    /**
     * 获取绘图数据
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @param  string $assess_type 评分类型 [ require true ]
     * @support  string $range 序列 
     * @throws  \Exception
     * @return  array
     */
    public static function getDraw (int $inventory_id, string $assess_type = 'opinion_value') {
        return self::getClass()->getDraw([
            "inventory_id" => $inventory_id,
            "assess_type" => $assess_type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\InventoryStatistic');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\InventoryStatistic');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}