<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addExamByParams(array $params)
 * @method updateExamByParams(array $params)
 */
class ExamManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加试卷【试卷配置】
     *
     * @support  string $category 分类名称 
     * @support  string $type 试题分类[知识巩固 - knowledge|技术训练 - ps_technology] 
     * @support  int $course_id 关联课程 
     * @support  int $pass_credit 奖励学分 [Original type uint] 
     * @support  string $name 试卷名称 [ require true ]
     * @support  int $pass_score 通过分数 [Original type uint] [ require true ]
     * @support  int $time 限时(秒) 
     * @support  array $question_config 题型配置 [ require true ]
     * @support  array $questions 题目 [ require true ]
     * @support  array $group_ids 关联分组 
     * @support  array $answer_times_limit 答题次数限制 
     * @support  array $can_rule 前置条件 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addExam () {
        return self::getClass()->addExam();
    }

    /**
     * 编辑试卷
     *
     * @support  int $id 试卷id [ require true ]
     * @support  string $category 分类名称 
     * @support  string $type 试题分类[知识巩固|技术训练] 
     * @support  int $course_id 关联课程 
     * @support  int $pass_credit 奖励学分 [Original type uint] [ require true ]
     * @support  string $name 试卷名称 [ require true ]
     * @support  int $pass_score 通过分数 [Original type uint] [ require true ]
     * @support  int $time 限时(秒) 
     * @support  array $question_config 题型配置 [ require true ]
     * @support  array $questions 题目 [ require true ]
     * @support  array $group_ids 关联分组 
     * @support  array $answer_times_limit 答题次数限制 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateExam () {
        return self::getClass()->updateExam();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'ExamManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'ExamManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}