<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method allByParams(array $params)
 * @method storedByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Inventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建盘点项目
     *
     * @param  string $name 盘点名称 [ require true ]
     * @support  array $configure 配置 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name) {
        return self::getClass()->create([
            "name" => $name,
        ]);
    }

    /**
     * 盘点列表
     *
     * @support  string $status 盘点状态 
     * @support  bool $with_count 统计盘点人数 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 存档
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stored (int $inventory_id) {
        return self::getClass()->stored([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 修改盘点信息
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @support  string $name 盘点名称 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $inventory_id) {
        return self::getClass()->update([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 删除盘点项
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $inventory_id) {
        return self::getClass()->delete([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\Inventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\Inventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}