<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Organization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchAddByParams(array $params)
 * @method listByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method getDepartmentJobMapByParams(array $params)
 */
class Establishment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量添加编制
     *
     * @support  array $data 添加数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchAdd () {
        return self::getClass()->batchAdd();
    }

    /**
     * 编制列表
     *
     * @support  int $department_id 部门id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 修改编制
     *
     * @support  array $data 修改编制的数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 取消编制
     *
     * @support  int $id 编制id数组 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 批量修改编制
     *
     * @support  array $data 数据数组 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate () {
        return self::getClass()->batchUpdate();
    }

    /**
     * 导出编制
     *
     * @support  string $date 导出月份 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 获取部门职位映射
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDepartmentJobMap () {
        return self::getClass()->getDepartmentJobMap();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Organization\Establishment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Organization\Establishment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}