<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Organization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method detailByParams(array $params)
 */
class Job {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增职位
     *
     * @param  string $name 职位名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function create (string $name) {
        return self::getClass()->create([
            "name" => $name,
        ]);
    }

    /**
     * 修改职位
     *
     * @param  int $id 职位id [Original type uint] [ require true ]
     * @param  string $name 职位名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, string $name) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 职位列表
     *
     * @support  string $name 名称搜索关键字 
     * @support  bool $with_count 是否返回职位下人数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 删除职位
     *
     * @param  int $id 职位id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 职位详情
     *
     * @param  int $id 职位id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Organization\Job');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Organization\Job');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}