<?php
namespace Mainto\Bridge\Invokes\OaProject\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInfoByParams(array $params)
 * @method breakCourseByParams(array $params)
 * @method courseListByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method onlineByParams(array $params)
 * @method offlineByParams(array $params)
 */
class Course {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 课程详情
     *
     * @support  int $id 课程ID [ require true ]
     * @support  int $staff_num 员工id 
     * @support  bool $with_learnData 包含课程学习资料信息 
     * @support  bool $with_children 包含课程学习资料信息 
     * @support  bool $with_label 包含标签信息 
     * @support  bool $with_teacher 包含讲师信息 
     * @support  bool $with_exam 包含课程测试信息 
     * @support  bool $with_learner_statis 课程学习人数 
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo () {
        return self::getClass()->getInfo();
    }

    /**
     * 中断课程
     *
     * @support  int $course_id 主课程id [ require true ]
     * @support  int $append_time 新增学习时间 [ require true ]
     * @support  int $current_time 学习到时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function breakCourse () {
        return self::getClass()->breakCourse();
    }

    /**
     * 课程列表(不分页)
     *
     * @support  array $category_ids 课程分类ids [Original type array&lt;int&gt;] 
     * @support  int $is_released 是否已上线 
     * @support  bool $with_groups_info 包含分组信息 
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  array
     */
    public static function courseList () {
        return self::getClass()->courseList();
    }

    /**
     * 课程列表【分页】
     *
     * @support  int $is_released 是否上线 
     * @support  array $category_ids 分类id 
     * @support  bool $with_exam 包含课程测试信息 
     * @support  bool $with_learnData 包含课程学习资料信息 
     * @support  bool $with_children 包含子课程信息 
     * @support  string $name 课程名称 
     * @support  string $apply_in 应用于 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $pageSize 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage () {
        return self::getClass()->getListByPage();
    }

    /**
     * 课程上线
     *
     * @param  int $id 主课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function online (int $id) {
        return self::getClass()->online([
            "id" => $id,
        ]);
    }

    /**
     * 课程下线
     *
     * @param  int $id 主课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline (int $id) {
        return self::getClass()->offline([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Course');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Course');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}