<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Organization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchAddByParams(array $params)
 * @method listByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method exportSeederByParams(array $params)
 * @method getDepartmentJobMapByParams(array $params)
 * @method establishmentChangedByParams(array $params)
 * @method establishmentDeletedByParams(array $params)
 * @method onStaffDeletedByParams(array $params)
 * @method onStaffCreatedByParams(array $params)
 * @method onStaffJoinByParams(array $params)
 * @method onStaffUpdateByParams(array $params)
 */
class Establishment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量添加编制
     *
     * @param  array $data 添加数据 [ require true ]
     * @param  bool $is_plan 是否为批量导入计划 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchAdd (array $data, bool $is_plan = false) {
        return self::getClass()->batchAdd([
            "data" => $data,
            "is_plan" => $is_plan,
        ]);
    }

    /**
     * 编制列表
     *
     * @param  int $department_id 部门id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $department_id) {
        return self::getClass()->list([
            "department_id" => $department_id,
        ]);
    }

    /**
     * 修改编制
     *
     * @param  array $data 修改编制的数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (array $data) {
        return self::getClass()->update([
            "data" => $data,
        ]);
    }

    /**
     * 取消编制
     *
     * @param  array $ids 要取消的编制id [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (array $ids) {
        return self::getClass()->delete([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量修改编制
     *
     * @param  array $data 数据数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 导出编制
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 导入表格填充数据
     *
     * @throws  \Exception
     * @return  array
     */
    public static function exportSeeder () {
        return self::getClass()->exportSeeder();
    }

    /**
     * 获取部门职位映射
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDepartmentJobMap () {
        return self::getClass()->getDepartmentJobMap();
    }

    /**
     * establishmentChanged
     *
     * @support  array $old 旧信息 
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function establishmentChanged (int $id) {
        return self::getClass()->establishmentChanged([
            "id" => $id,
        ]);
    }

    /**
     * establishmentDeleted
     *
     * @param  array $ids 删除的ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function establishmentDeleted (array $ids) {
        return self::getClass()->establishmentDeleted([
            "ids" => $ids,
        ]);
    }

    /**
     * onStaffDeleted
     *
     * @param  int $staff_id 伙伴id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onStaffDeleted (int $staff_id) {
        return self::getClass()->onStaffDeleted([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * onStaffCreated
     *
     * @param  int $staff_id 伙伴id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onStaffCreated (int $staff_id) {
        return self::getClass()->onStaffCreated([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * onStaffJoin
     *
     * @param  int $staff_id 伙伴id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onStaffJoin (int $staff_id) {
        return self::getClass()->onStaffJoin([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 伙伴更新事件
     *
     * @param  array $old_staff 伙伴旧信息 [ require true ]
     * @param  array $new_staff 伙伴新信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onStaffUpdate (array $old_staff, array $new_staff) {
        return self::getClass()->onStaffUpdate([
            "old_staff" => $old_staff,
            "new_staff" => $new_staff,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Organization\Establishment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Organization\Establishment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}