<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method archiveConfigListByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method getInfoByParams(array $params)
 */
class StaffArchive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 档案配置列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function archiveConfigList () {
        return self::getClass()->archiveConfigList();
    }

    /**
     * 批量导入伙伴档案
     *
     * @param  array $archive_info json数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (array $archive_info) {
        return self::getClass()->batchCreate([
            "archive_info" => $archive_info,
        ]);
    }

    /**
     * 添加伙伴档案
     *
     * @param  int $id 工号 [Original type uint] [ require true ]
     * @param  string $remark 备注 [ require true ]
     * @param  array $extra_info json数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $id, string $remark, array $extra_info) {
        return self::getClass()->create([
            "id" => $id,
            "remark" => $remark,
            "extra_info" => $extra_info,
        ]);
    }

    /**
     * 修改伙伴档案
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  string $remark 备注 [ require true ]
     * @param  array $extra_info json数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, string $remark, array $extra_info) {
        return self::getClass()->update([
            "id" => $id,
            "remark" => $remark,
            "extra_info" => $extra_info,
        ]);
    }

    /**
     * 伙伴档案列表
     *
     * @support  array $dept_ids 部门ids [Original type array&lt;uint&gt;] 
     * @support  array $position_ids 职位ids [Original type array&lt;uint&gt;] 
     * @param  bool $with_delete 包含离职 [ require true ]
     * @param  bool $only_delete 只要离职 [ require true ]
     * @support  int $staff_id 工号 [Original type uint] 
     * @support  string $nickname 昵称 
     * @support  string $name 姓名 
     * @support  string $completion 完整度 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (bool $with_delete = false, bool $only_delete = false, int $page = 1, int $page_size = 10) {
        return self::getClass()->list([
            "with_delete" => $with_delete,
            "only_delete" => $only_delete,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 获取导出详情接口
     *
     * @param  string $task_id 任务id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (string $task_id) {
        return self::getClass()->getInfo([
            "task_id" => $task_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Staff\StaffArchive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Staff\StaffArchive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}