<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method executeByParams(array $params)
 */
class StaffAdjust {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建
     *
     * @param  int $staff_id 工号 [Original type uint] [ require true ]
     * @param  array $new_data 调整后数据 [ require true ]
     * @param  string $adjust_at 调整时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $staff_id, array $new_data, string $adjust_at) {
        return self::getClass()->create([
            "staff_id" => $staff_id,
            "new_data" => $new_data,
            "adjust_at" => $adjust_at,
        ]);
    }

    /**
     * 修改
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  array $new_data 调整后数据 [ require true ]
     * @param  string $adjust_at 调整时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, array $new_data, string $adjust_at) {
        return self::getClass()->update([
            "id" => $id,
            "new_data" => $new_data,
            "adjust_at" => $adjust_at,
        ]);
    }

    /**
     * 预调整职位定时任务
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function execute () {
        return self::getClass()->execute();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Staff\StaffAdjust');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Staff\StaffAdjust');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}