<?php
namespace Mainto\Bridge\Invokes\OaProject\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method stageHookByParams(array $params)
 * @method createArchiveByParams(array $params)
 * @method updateArchiveByParams(array $params)
 * @method deleteStaffByParams(array $params)
 * @method syncPhoneFromDingTalkByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 课程完成学习阶段调整-回调监听
     *
     * @param  int $course_id 课程id [ require true ]
     * @param  int $archive_id 档案id [ require true ]
     * @param  int $staff_num 员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stageHook (int $course_id, int $archive_id, int $staff_num) {
        return self::getClass()->stageHook([
            "course_id" => $course_id,
            "archive_id" => $archive_id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 课程完成学习阶段调整-回调监听
     *
     * @param  int $staff_id 员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createArchive (int $staff_id) {
        return self::getClass()->createArchive([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 职级变更，更新学习阶段
     *
     * @param  array $new_staff 员工新更新信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateArchive (array $new_staff) {
        return self::getClass()->updateArchive([
            "new_staff" => $new_staff,
        ]);
    }

    /**
     * 离职员工
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteStaff () {
        return self::getClass()->deleteStaff();
    }

    /**
     * 从钉钉同步手机号
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncPhoneFromDingTalk () {
        return self::getClass()->syncPhoneFromDingTalk();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}