<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByPageByParams(array $params)
 * @method getNewPeopleListByPageByParams(array $params)
 * @method tagNewPeopleByParams(array $params)
 * @method unTagNewPeopleByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getScheduleListByParams(array $params)
 * @method addRemindByParams(array $params)
 * @method isRemindByParams(array $params)
 */
class ArchiveManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取档案列表
     *
     * @support  array $store_ids 门店id [Original type array&lt;int&gt;] 
     * @param  int $position_id 职位id [ require true ]
     * @support  string $name 伙伴姓名 
     * @support  string $nickname 伙伴花名 
     * @support  int $staff_num 伙伴工号 
     * @support  int $page 页码 
     * @support  int $pageSize 每页显示数 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $position_id) {
        return self::getClass()->getListByPage([
            "position_id" => $position_id,
        ]);
    }

    /**
     * 获取新人列表
     *
     * @support  array $store_ids 门店id [Original type array&lt;int&gt;] 
     * @support  int $position_id 职位id 
     * @support  string $name 伙伴姓名 
     * @support  string $nickname 伙伴花名 
     * @support  int $staff_num 伙伴工号 [Original type uint] 
     * @param  bool $withDept 是否返回部门 [ require true ]
     * @param  bool $withArea 是否返回地区 [ require true ]
     * @support  bool $is_new 是否返回新人 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页显示数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNewPeopleListByPage (int $page, int $pageSize, bool $withDept = false, bool $withArea = false) {
        return self::getClass()->getNewPeopleListByPage([
            "page" => $page,
            "pageSize" => $pageSize,
            "withDept" => $withDept,
            "withArea" => $withArea,
        ]);
    }

    /**
     * 标记新人
     *
     * @param  int $staffId 员工id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function tagNewPeople (int $staffId) {
        return self::getClass()->tagNewPeople([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 取消标记新人
     *
     * @param  int $staffId 员工id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unTagNewPeople (int $staffId) {
        return self::getClass()->unTagNewPeople([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取档案详情
     *
     * @param  int $staff_num 员工工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $staff_num) {
        return self::getClass()->getInfo([
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 获取进度列表
     *
     * @param  int $staff_num 员工工号 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getScheduleList (int $staff_num, int $page, int $pageSize) {
        return self::getClass()->getScheduleList([
            "staff_num" => $staff_num,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 添加提醒
     *
     * @param  int $staff_num 工号 [ require true ]
     * @param  string $msg 消息内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addRemind (int $staff_num, string $msg) {
        return self::getClass()->addRemind([
            "staff_num" => $staff_num,
            "msg" => $msg,
        ]);
    }

    /**
     * 验证是否重复提醒
     *
     * @param  int $staff_num 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function isRemind (int $staff_num) {
        return self::getClass()->isRemind([
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'ArchiveManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'ArchiveManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}