<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserInfoByParams(array $params)
 * @method getListByParams(array $params)
 * @method getRankingListByParams(array $params)
 * @method getMessageListByParams(array $params)
 * @method readByParams(array $params)
 * @method getDateCountItemByParams(array $params)
 */
class StoreArchive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 个人档案(用户端)
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserInfo () {
        return self::getClass()->getUserInfo();
    }

    /**
     * 个人学习动态(用户端)
     *
     * @support  string $date_start 日期起 
     * @support  string $date_end 日期止 
     * @support  string $item_name 类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 排行榜
     *
     * @support  string $item_name 排行项 [ require true ]
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 页码 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getRankingList () {
        return self::getClass()->getRankingList();
    }

    /**
     * 获取员工提醒
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMessageList () {
        return self::getClass()->getMessageList();
    }

    /**
     * 设为阅读
     *
     * @param  int $id 消息id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function read (int $id) {
        return self::getClass()->read([
            "id" => $id,
        ]);
    }

    /**
     * 数据统计类型【档案】
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getDateCountItem () {
        return self::getClass()->getDateCountItem();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'StoreArchive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'StoreArchive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}