<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method listPageByParams(array $params)
 * @method keywordSearchByParams(array $params)
 * @method checkStaffActiveByParams(array $params)
 * @method configListByParams(array $params)
 * @method levelListByParams(array $params)
 * @method contractSubjectListByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method leaveByParams(array $params)
 * @method executeLeaveByParams(array $params)
 * @method leaveListByParams(array $params)
 * @method goBackByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method checkIdNumberByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询伙伴信息-返回伙伴基础信息和职位信息 无条件 则返回空
     *
     * @support  array $staff_ids 工号ids [Original type array&lt;uint&gt;] 
     * @support  array $dept_ids 部门ids [Original type array&lt;uint&gt;] 
     * @support  array $position_ids 职位ids [Original type array&lt;uint&gt;] 
     * @param  bool $with_delete 包含离职 [ require true ]
     * @support  bool $only_delete 只要离职 
     * @support  string $keyword 工号|花名|姓名 
     * @throws  \Exception
     * @return  mixed
     */
    public static function all (bool $with_delete = false) {
        return self::getClass()->all([
            "with_delete" => $with_delete,
        ]);
    }

    /**
     * 查询伙伴信息[分页]
     *
     * @support  array $staff_ids 工号ids [Original type array&lt;uint&gt;] 
     * @support  array $dept_ids 部门ids [Original type array&lt;uint&gt;] 
     * @support  array $position_ids 职位ids [Original type array&lt;uint&gt;] 
     * @param  bool $with_delete 包含离职 [ require true ]
     * @support  bool $only_delete 只要离职 
     * @support  string $keyword 工号|花名|姓名 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listPage (bool $with_delete = false, int $page = 1, int $page_size = 15) {
        return self::getClass()->listPage([
            "with_delete" => $with_delete,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 工号花名姓名搜索
     *
     * @param  string $keyword 工号|花名|姓名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function keywordSearch (string $keyword) {
        return self::getClass()->keywordSearch([
            "keyword" => $keyword,
        ]);
    }

    /**
     * 检测工号可用
     *
     * @param  array $staff_ids 伙伴工号 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkStaffActive (array $staff_ids) {
        return self::getClass()->checkStaffActive([
            "staff_ids" => $staff_ids,
        ]);
    }

    /**
     * 配置列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function configList () {
        return self::getClass()->configList();
    }

    /**
     * 职级列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function levelList () {
        return self::getClass()->levelList();
    }

    /**
     * 合同主体列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function contractSubjectList () {
        return self::getClass()->contractSubjectList();
    }

    /**
     * 录入
     *
     * @param  string $name 姓名 [ require true ]
     * @support  string $nickname 花名 
     * @support  string $status 员工状态 [ require true ]
     * @support  string $type 员工类型 [ require true ]
     * @param  string $entry_at 入职日期 [ require true ]
     * @support  string $positive_at 转正日期 [ require true ]
     * @param  string $phone 手机 [ require true ]
     * @support  string $rest_type 休息类型 [ require true ]
     * @support  string $remark 备注 
     * @param  int $department_id 部门id [Original type uint] [ require true ]
     * @param  int $position_id 职位id [Original type uint] [ require true ]
     * @param  string $level 职级 [ require true ]
     * @support  string $attribute 伙伴属性(自有或加盟) [ require true ]
     * @support  string $job_title 技术职称 
     * @support  string $job_type 工作组(组长或无) 
     * @support  array $personal_info 个人其他信息 [ require true ]
     * @support  array $contract_info 合同信息 [ require true ]
     * @support  array $education_info 学历信息 [ require true ]
     * @support  array $experience_info 工作经历信息 
     * @support  array $annex 附件 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, string $entry_at, string $phone, int $department_id, int $position_id, string $level) {
        return self::getClass()->create([
            "name" => $name,
            "entry_at" => $entry_at,
            "phone" => $phone,
            "department_id" => $department_id,
            "position_id" => $position_id,
            "level" => $level,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $id 工号 [Original type uint] [ require true ]
     * @support  string $name 姓名 
     * @support  string $nickname 花名 
     * @support  string $status 员工状态 
     * @support  string $type 员工类型 
     * @support  string $entry_at 入职日期 
     * @support  string $positive_at 转正日期 
     * @support  string $phone 手机 
     * @support  string $rest_type 休息类型 
     * @support  string $remark 备注 
     * @support  int $department_id 部门id [Original type uint] 
     * @support  int $position_id 职位id [Original type uint] 
     * @support  string $level 职级 
     * @support  string $attribute 伙伴属性(自有或加盟) 
     * @support  string $job_title 技术职称 
     * @support  string $job_type 工作组(组长或无) 
     * @support  array $personal_info 个人其他信息 
     * @support  array $annex 附件 
     * @support  string $dingding_uid 钉钉id 
     * @support  string $leave_at 离职时间 
     * @support  string $leave_reason 离职原因 
     * @support  string $leave_remark 离职备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 列表
     *
     * @support  array $department_ids 部门id 
     * @support  int $position_id 职位 [Original type uint] 
     * @support  string $level 职级 
     * @support  string $entry_at_start 入职开始时间 
     * @support  string $entry_at_end 入职结束时间 
     * @support  string $positive_at_start 转正开始时间 
     * @support  string $positive_at_end 转正结束时间 
     * @support  string $end_at_start 合同开始时间 
     * @support  string $end_at_end 合同结束时间 
     * @support  int $id 工号 [Original type uint] 
     * @support  string $name 姓名 
     * @support  string $nickname 花名 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $page_size = 10) {
        return self::getClass()->list([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $id 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 批量录入
     *
     * @support  array $info json数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate();
    }

    /**
     * 批量修改
     *
     * @support  array $info json数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate () {
        return self::getClass()->batchUpdate();
    }

    /**
     * 离职
     *
     * @param  int $id 工号 [Original type uint] [ require true ]
     * @param  string $leave_at 离职时间 [ require true ]
     * @param  string $leave_reason 离职原因 [ require true ]
     * @param  string $leave_remark 离职备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function leave (int $id, string $leave_at, string $leave_reason, string $leave_remark = NULL) {
        return self::getClass()->leave([
            "id" => $id,
            "leave_at" => $leave_at,
            "leave_reason" => $leave_reason,
            "leave_remark" => $leave_remark,
        ]);
    }

    /**
     * 离职定时任务
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function executeLeave () {
        return self::getClass()->executeLeave();
    }

    /**
     * 离职列表
     *
     * @support  array $department_ids 部门id 
     * @support  int $position_id 职位 [Original type uint] 
     * @support  string $level 职级 
     * @support  string $leave_at_start 离职开始时间 
     * @support  string $leave_at_end 离职结束时间 
     * @support  int $id 工号 [Original type uint] 
     * @support  string $name 姓名 
     * @support  string $nickname 花名 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function leaveList (int $page = 1, int $page_size = 10) {
        return self::getClass()->leaveList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 复职
     *
     * @param  int $id 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function goBack (int $id) {
        return self::getClass()->goBack([
            "id" => $id,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 获取导出详情接口
     *
     * @param  string $task_id 任务id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (string $task_id) {
        return self::getClass()->getInfo([
            "task_id" => $task_id,
        ]);
    }

    /**
     * 检测身份证号
     *
     * @param  string $id_number 身份证号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function checkIdNumber (string $id_number) {
        return self::getClass()->checkIdNumber([
            "id_number" => $id_number,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Staff\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Staff\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}