<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 */
class Assessment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @param  float $version 版本 [Original type double] [ require true ]
     * @param  array $assessments 考核项 [ require true ]
     * @param  string $assess_type 考核类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (float $version, array $assessments, string $assess_type) {
        return self::getClass()->create([
            "version" => $version,
            "assessments" => $assessments,
            "assess_type" => $assess_type,
        ]);
    }

    /**
     * 盘点考核表
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @param  string $assess_type 考核类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $inventory_id, string $assess_type) {
        return self::getClass()->detail([
            "inventory_id" => $inventory_id,
            "assess_type" => $assess_type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\Assessment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\Assessment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}