<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Organization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchAddByParams(array $params)
 * @method listByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method exportSeederByParams(array $params)
 * @method getDepartmentJobMapByParams(array $params)
 * @method newEstablishmentByParams(array $params)
 */
class Establishment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量添加编制
     *
     * @param  array $data 添加数据 [ require true ]
     * @param  bool $is_plan 是否为批量导入计划 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchAdd (array $data, bool $is_plan = false) {
        return self::getClass()->batchAdd([
            "data" => $data,
            "is_plan" => $is_plan,
        ]);
    }

    /**
     * 编制列表
     *
     * @param  int $department_id 部门id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $department_id) {
        return self::getClass()->list([
            "department_id" => $department_id,
        ]);
    }

    /**
     * 修改编制
     *
     * @param  array $data 修改编制的数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (array $data) {
        return self::getClass()->update([
            "data" => $data,
        ]);
    }

    /**
     * 取消编制
     *
     * @param  array $ids 要取消的编制id [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (array $ids) {
        return self::getClass()->delete([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量修改编制
     *
     * @param  array $data 数据数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 导出编制
     *
     * @support  string $date 导出月份 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 导入表格填充数据
     *
     * @throws  \Exception
     * @return  array
     */
    public static function exportSeeder () {
        return self::getClass()->exportSeeder();
    }

    /**
     * 获取部门职位映射
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDepartmentJobMap () {
        return self::getClass()->getDepartmentJobMap();
    }

    /**
     * newEstablishment
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function newEstablishment () {
        return self::getClass()->newEstablishment();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Organization\Establishment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Organization\Establishment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}