<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\StoreTrain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method trainingExampleExportByParams(array $params)
 * @method storeExampleExportByParams(array $params)
 */
class Example {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表查询【泽维尔】导出
     *
     * @support  string $title 标题 
     * @support  int $category_id 分类id [Original type uint] 
     * @support  bool $is_released 是否上线 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页数量 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function trainingExampleExport () {
        return self::getClass()->trainingExampleExport();
    }

    /**
     * 列表查询【门店伙伴】导出
     *
     * @support  string $title 标题 
     * @support  array $category_ids 分类id [Original type array&lt;int&gt;] 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页数量 [Original type uint] 
     * @support  string $created_at_start 创建时间起 
     * @support  string $created_at_end 创建时间止 
     * @throws  \Exception
     * @return  array
     */
    public static function storeExampleExport () {
        return self::getClass()->storeExampleExport();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\StoreTrain\Example');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\StoreTrain\Example');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}