<?php
namespace Mainto\Bridge\Invokes\OaProject\Store\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addNoteByParams(array $params)
 * @method updateNoteByParams(array $params)
 * @method deleteNoteByParams(array $params)
 * @method getNoteListByParams(array $params)
 * @method getNoteInfoByParams(array $params)
 */
class StoreNote {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建笔记
     *
     * @support  string $title 标题 [ require true ]
     * @support  string $content 内容 [ require true ]
     * @support  int $from_course 课程id [Original type uint] 
     * @support  string $experience 感悟 
     * @throws  \Exception
     * @return  int
     */
    public static function addNote () {
        return self::getClass()->addNote();
    }

    /**
     * 修改笔记
     *
     * @support  int $id 笔记id [ require true ]
     * @support  string $title 笔记标签 [ require true ]
     * @support  string $content 笔记内容 [ require true ]
     * @support  string $experience 课程感悟 
     * @support  int $from_course 课程id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateNote () {
        return self::getClass()->updateNote();
    }

    /**
     * 删除笔记
     *
     * @param  int $id 笔记id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteNote (int $id) {
        return self::getClass()->deleteNote([
            "id" => $id,
        ]);
    }

    /**
     * getNoteList
     *
     * @support  string $name 笔记名称【模糊查询】 
     * @support  int $page 页码 
     * @support  int $pageSize 每页显示数据 
     * @throws  \Exception
     * @return  array
     */
    public static function getNoteList () {
        return self::getClass()->getNoteList();
    }

    /**
     * 获取笔记详情
     *
     * @param  int $id 笔记id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNoteInfo (int $id) {
        return self::getClass()->getNoteInfo([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'StoreNote');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'StoreNote');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}