<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-31 11:10:39
 */
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Sms
 */
class Sms {
    private static string $serviceName = "Notify";

    private static string $className = "Sms";

    /**
     * 获取短信验证码
     * @return  string
    */
    public static function getSmsCode (string $type, string $phone, string $code, string $captcha) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSmsCode(["type" => $type, "phone" => $phone, "code" => $code, "captcha" => $captcha]);
    }
    /**
     * 获取短信验证码无需通过验证 （仅后台使用）
     * @return  string
    */
    public static function getSmsCodeWithoutCaption (string $type, string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSmsCodeWithoutCaption(["type" => $type, "phone" => $phone]);
    }
    /**
     * 获取指定短信验证码无需通过验证 （仅后台使用）
     * @return  string
    */
    public static function getSmsCodeWithCodeWithoutCaption (string $type, string $phone, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSmsCodeWithCodeWithoutCaption(["type" => $type, "phone" => $phone, "code" => $code]);
    }
    /**
     * 通过无痕验证后发送短信验证码
     * @return  mixed
    */
    public static function getSmsCodeWithInvisible (string $type, string $phone, string $token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSmsCodeWithInvisible(["type" => $type, "phone" => $phone, "token" => $token]);
    }
    /**
     * 验证token并发送短信验证码
     * @return  mixed
    */
    public static function getSmsCodeByToken (string $type, string $phone, string $tokenType, string $token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSmsCodeByToken(["type" => $type, "phone" => $phone, "tokenType" => $tokenType, "token" => $token]);
    }
    /**
     * 检查验证码是否正确
     * @return  bool
    */
    public static function checkSmsCode (string $phone, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkSmsCode(["phone" => $phone, "code" => $code]);
    }
    /**
     * 获取验证码
     * @return  mixed
    */
    public static function captcha (string $type, string $code, string $extend = '', string $mode = 'base64') {
        return RpcClass::getClass(self::$serviceName, self::$className)->captcha(["type" => $type, "code" => $code, "extend" => $extend, "mode" => $mode]);
    }
    /**
     * 发送通知短信
     * @return  bool
    */
    public static function sendNotifySms (string $type, string $phone, string $template, array $data = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendNotifySms(["type" => $type, "phone" => $phone, "template" => $template, "data" => $data]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}