<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-31 11:21:06
 */
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Ding
 */
class Ding {
    private static string $serviceName = "Notify";

    private static string $className = "Ding";

    /**
     * 获取 钉钉开放平台 AccessToken
     * @return  \Mainto\Bridge\Structs\Notify\DTO\Ding\DingTalkAccessTokenDTO
    */
    public static function getDingTalkAccessToken () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDingTalkAccessToken(),
            "\Mainto\Bridge\Structs\Notify\DTO\Ding\DingTalkAccessTokenDTO"
        );
    }
    /**
     * 发送工作通知
     * @return  bool
    */
    public static function sendWorkNotice (array $msg_package, array $staff_ding_ids = [], array $department_ids = [], string $agentId = '', bool $to_all_user = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendWorkNotice(["msg_package" => $msg_package, "staff_ding_ids" => $staff_ding_ids, "department_ids" => $department_ids, "agentId" => $agentId, "to_all_user" => $to_all_user]);
    }
    /**
     * 获取部门用户ding_user_ids
     * @return  array
    */
    public static function getDepartmentUserIds (string $dingTalkDepId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartmentUserIds(["dingTalkDepId" => $dingTalkDepId]);
    }
    /**
     * 创建部门
     * @return  string
    */
    public static function createDingTalkDep (string $name, string $parentId, bool $createDeptGroup = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createDingTalkDep(["name" => $name, "parentId" => $parentId, "createDeptGroup" => $createDeptGroup]);
    }
    /**
     * 修改钉钉部门
     * @return  bool
    */
    public static function updateDingTalkDep (string $dingTalkDepId, string $name = '', string $parentId = '', array $dingManaegerIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateDingTalkDep(["dingTalkDepId" => $dingTalkDepId, "name" => $name, "parentId" => $parentId, "dingManaegerIds" => $dingManaegerIds]);
    }
    /**
     * 获取钉钉部门信息
     * @return  \Mainto\Bridge\Structs\Notify\DTO\Ding\DepartmentDetailDTO
    */
    public static function getDingTalkDepDetail (string $dingTalkDepId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDingTalkDepDetail(["dingTalkDepId" => $dingTalkDepId]),
            "\Mainto\Bridge\Structs\Notify\DTO\Ding\DepartmentDetailDTO"
        );
    }
    /**
     * 获取钉钉部门信息
     * @return  \Mainto\Bridge\Structs\Notify\DTO\Ding\DepartmentDetailDTO
    */
    public static function getDeptByDingTalkDepId (string $dingTalkDepId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDeptByDingTalkDepId(["dingTalkDepId" => $dingTalkDepId]),
            "\Mainto\Bridge\Structs\Notify\DTO\Ding\DepartmentDetailDTO"
        );
    }
    /**
     * 删除钉钉部门
     * @return  bool
    */
    public static function delDingTalkDep (string $dingTalkDepId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delDingTalkDep(["dingTalkDepId" => $dingTalkDepId]);
    }
    /**
     * 创建钉钉伙伴
     * @return  string
    */
    public static function createDingTalkStaff (array $staffInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createDingTalkStaff(["staffInfo" => $staffInfo]);
    }
    /**
     * 更新钉钉伙伴信息
     * @return  bool
    */
    public static function updateDingTalkStaff (string $dingTalkStaffId, array $staffInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateDingTalkStaff(["dingTalkStaffId" => $dingTalkStaffId, "staffInfo" => $staffInfo]);
    }
    /**
     * 删除钉钉伙伴信息
     * @return  bool
    */
    public static function deleteDingTalkStaff (string $dingTalkStaffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteDingTalkStaff(["dingTalkStaffId" => $dingTalkStaffId]);
    }
    /**
     * 根据钉钉伙伴id获取钉钉详情
     * @return  \Mainto\Bridge\Structs\Notify\DTO\Ding\DingUserDetailDTO
    */
    public static function getDingTalkStaffByDingId (string $dingTalkStaffId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDingTalkStaffByDingId(["dingTalkStaffId" => $dingTalkStaffId]),
            "\Mainto\Bridge\Structs\Notify\DTO\Ding\DingUserDetailDTO"
        );
    }
    /**
     * 创建审批
     * @return  string
    */
    public static function createProcess (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createProcess(["data" => $data]);
    }
    /**
     * 终止审批
     * @return  bool
    */
    public static function terminateProcess (string $instanceId, bool $isSystem = false, string $remark, string $operatorUserId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->terminateProcess(["instanceId" => $instanceId, "isSystem" => $isSystem, "remark" => $remark, "operatorUserId" => $operatorUserId]);
    }
    /**
     * 审批实例ids列表
     * @return  array
    */
    public static function getProcessInstanceIds (string $processCode, string $startTimestamp, string $endTimestamp, array $userIdList = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProcessInstanceIds(["processCode" => $processCode, "startTimestamp" => $startTimestamp, "endTimestamp" => $endTimestamp, "userIdList" => $userIdList]);
    }
    /**
     * 审批回调
     * @return  string
    */
    public static function receiveProcessCallback () {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveProcessCallback();
    }
    /**
     * 获取h5 调用api 需要的鉴权值
     * @return  \Mainto\Bridge\Structs\Notify\DTO\Ding\DingH5JsApiTicketDTO
    */
    public static function getH5Sign (string $url, string $appkey = null, string $appsecret = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getH5Sign(["url" => $url, "appkey" => $appkey, "appsecret" => $appsecret]),
            "\Mainto\Bridge\Structs\Notify\DTO\Ding\DingH5JsApiTicketDTO"
        );
    }
    /**
     * 获取注册钉钉回调请求数据
     * @return  \Mainto\Bridge\Structs\Notify\DTO\Ding\RegisterCallBackDTO
    */
    public static function registerDingCallback (string $callback_name) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->registerDingCallback(["callback_name" => $callback_name]),
            "\Mainto\Bridge\Structs\Notify\DTO\Ding\RegisterCallBackDTO"
        );
    }
    /**
     * 查询已经注册的钉钉回调地址
     * @return  mixed
    */
    public static function queryDingCallbackList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryDingCallbackList();
    }
    /**
     * 获取审批实例详情
     * @return  mixed
    */
    public static function getProcessInstanceDetail (string $processInstanceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProcessInstanceDetail(["processInstanceId" => $processInstanceId]);
    }
    /**
     * 查询某个伙伴的所有上级列表
     * @return  array
    */
    public static function queryDeptManagerByStaff (string $dingTalkId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryDeptManagerByStaff(["dingTalkId" => $dingTalkId]);
    }
    /**
     * 根据Code获取用户信息
     * @return  \Mainto\Bridge\Structs\Notify\DTO\Ding\DingUserDetailDTO
    */
    public static function getUserByCode (string $code) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserByCode(["code" => $code]),
            "\Mainto\Bridge\Structs\Notify\DTO\Ding\DingUserDetailDTO"
        );
    }
    /**
     * 内部获取钉钉排班表
     * @return  mixed
    */
    public static function getStaffScheduleByUserIds (string $opUserId, string $appKey, string $appSecret, array $userIds, string $fromTime, string $toTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffScheduleByUserIds(["opUserId" => $opUserId, "appKey" => $appKey, "appSecret" => $appSecret, "userIds" => $userIds, "fromTime" => $fromTime, "toTime" => $toTime]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}