<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-30 11:58:41
 */
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Message
 */
class Message {
    private static string $serviceName = "Notify";

    private static string $className = "Message";

    /**
     * 发送工作通知
    */
    public static function asyncSendWorkNotice (array $msgContent): ?bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->asyncSendWorkNotice(["msgContent" => $msgContent]);
    }
    /**
     * 发送站内信
    */
    public static function sendMessage (int $from, int $to, string $title, string $application, string $msg, string $type = ''): ?bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendMessage(["from" => $from, "to" => $to, "title" => $title, "application" => $application, "msg" => $msg, "type" => $type]);
    }
    /**
     * 信息列表
    */
    public static function msgList (int $staffId, int $is_read = 2, int $from = 0, string $application = '', string $type = '', int $page = 1, int $pageSize = 15) {
        return RpcClass::getClass(self::$serviceName, self::$className)->msgList(["staffId" => $staffId, "is_read" => $is_read, "from" => $from, "application" => $application, "type" => $type, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 消息详情
    */
    public static function msgDetail (int $msgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->msgDetail(["msgId" => $msgId]);
    }
    /**
     * 修改为已读
    */
    public static function readMsg (int $msgId): ?bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->readMsg(["msgId" => $msgId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}