<?php
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendUnicastByParams(array $params)
 * @method sendListcastByParams(array $params)
 */
class Umeng {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 友盟单播推送
     *
     * @param  string $deviceToken 友盟设备token [ require true ]
     * @param  array $predefinedKeys payload数据，kv结构数组 [ require true ]
     * @param  array $fieldKeys 自定义需要app处理的数据，如安卓的extra，ios的自定义数据 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendUnicast (string $deviceToken, array $predefinedKeys, array $fieldKeys = []) {
        return self::getClass()->sendUnicast([
            "deviceToken" => $deviceToken,
            "predefinedKeys" => $predefinedKeys,
            "fieldKeys" => $fieldKeys,
        ]);
    }

    /**
     * 友盟列播推送
     *
     * @param  array $deviceTokenArray 友盟设备token的数组 [ require true ]
     * @param  array $predefinedKeys payload数据，kv结构数组 [ require true ]
     * @param  array $fieldKeys 自定义需要app处理的数据，如安卓的extra，ios的自定义数据 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendListcast (array $deviceTokenArray, array $predefinedKeys, array $fieldKeys = []) {
        return self::getClass()->sendListcast([
            "deviceTokenArray" => $deviceTokenArray,
            "predefinedKeys" => $predefinedKeys,
            "fieldKeys" => $fieldKeys,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Notify', 'Umeng');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Notify', 'Umeng');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}