<?php
namespace Mainto\Bridge\Enums\Notify\DingTalk;

class DingErrCodeEnum {
    const OK = 0;
    /**
     * 应用IP白名单未通过(需要到后台配置服务出口IP)
     */
    const IP_ACCESS_ERROR = 60020;
    /**
     * 没有接口权限(需要到钉钉应用后台配置接口权限)
     */
    const NO_AUTH = 60011;
    /**
     * 当钉钉上所有企业所有应用调用同一个接口超过最高频率时，触发限流，返回错误码90002。
     */
    const GLOBAL_LIMIT_FREQUENCY = 90002;
    const API_LIMIT_FREQUENCY_SECOND = 90018;
    const API_LIMIT_FREQUENCY_MINUTE = 90006;
    /**
     * 调用频率限制错误码列表
     */
    const INVOCATION_FREQUENCY_LIMIT_CODES = [0 => 90002,1 => 90018,2 => 90006];
}